/**
 * 
 */
/**
 * @author Janet Lopez
 *
 */
package gov.va.genisis2Test.service.impl;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.mockito.Mockito.when;

import org.junit.Test;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.model.Users;
import gov.va.genisis2.service.impl.UserManagementService;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;
import gov.va.genisis2Test.util.Helper;

/**
 * The Class UserManagementServiceTest.
 *
 * @author1 Janet Lopez
 * 
 *          The Class UserManagementServiceTest.
 * 
 *          Description: In this UserManagementServiceTest Class which extends
 *          the abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class UserManagementServiceTest extends AbstractMockMvcTests {

	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(UserManagementServiceTest.class);

	/**
	 * This method is used to TestUserManagementService.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testUserManagementService() throws Exception {
		logger.info("**********Junit Test User Management Service**********");

		UserManagementService userManagementService = new UserManagementService();
		
		assertNull(userManagementService.getUserManagementDAO());
		userManagementService.setUserManagementDAO(getMockUserManagementDao());
		assertNotNull(userManagementService.getUserManagementDAO());

		int id = userManagementService.submitOrModifyUser(Helper.getNewUser());
		assertNotNull(id);

		Users userDetailsByEmail = userManagementService.getUserDetailsByEmail("genisisad@gmail.com");
		when(userManagementService.getUserDetailsByEmail("genisisad@gmail.com")).thenReturn(userDetailsByEmail);

		Users userDetailsById = userManagementService.getUserDetailsById(id);
		when(userManagementService.getUserDetailsById(id)).thenReturn(userDetailsById);
		
		String userRole = userManagementService.getUserRole(1);
		when( userManagementService.getUserRole(1)).thenReturn(userRole);

		logger.info("**********End Junit Test User Management Service**********");

	}
}
